/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolModuleHooks;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.WettingModifier;

public class SpillingModifier
extends WettingModifier
implements EntityInteractionModifierHook {
    @Override
    public ToolAttackContext createContext(class_1309 self, @Nullable class_1657 player, @Nullable class_1297 attacker, FluidStack fluid) {
        class_1309 living;
        assert (attacker != null);
        SpillingModifier.spawnParticles(attacker, fluid);
        return new ToolAttackContext(self, player, class_1268.field_5808, attacker, attacker instanceof class_1309 ? (living = (class_1309)attacker) : null, false, 1.0f, false);
    }

    @Override
    protected boolean doesTrigger(class_1282 source, boolean isDirectDamage) {
        return source.method_5529() != null && isDirectDamage;
    }

    private void spillFluid(IToolStackView tool, int level, ToolAttackContext context, FluidStack fluid) {
        SpillingFluid recipe;
        if (!fluid.isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            FluidStack remaining = recipe.applyEffects(fluid, level, context);
            SpillingModifier.spawnParticles(context.getTarget(), fluid);
            class_1657 player = context.getPlayerAttacker();
            if (player == null || !player.method_7337()) {
                this.setFluid(tool, remaining);
            }
        }
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (damageDealt > 0.0f && context.isFullyCharged()) {
            this.spillFluid(tool, level, context, this.getFluid(tool));
        }
        return 0;
    }

    @Override
    public class_1269 beforeEntityUse(IToolStackView tool, ModifierEntry modifier, class_1657 player, class_1297 target, class_1268 hand, InteractionSource source) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (source != InteractionSource.ARMOR && !tool.hasTag(TinkerTags.Items.MELEE) && tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source) && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            if (!player.method_37908().field_9236) {
                class_1309 l;
                int level = modifier.getLevel();
                ToolAttackContext context = new ToolAttackContext((class_1309)player, player, hand, target, target instanceof class_1309 ? (l = (class_1309)target) : null, false, 1.0f, false);
                FluidStack remaining = recipe.applyEffects(fluid.copy(), level, context);
                SpillingModifier.spawnParticles(target, fluid);
                if (!player.method_7337()) {
                    this.setFluid(tool, remaining);
                }
                int numTargets = 1;
                float range = 1 + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
                float rangeSq = range * range;
                for (class_1297 aoeTarget : player.method_37908().method_18467(class_1297.class, target.method_5829().method_1009((double)range, 0.25, (double)range))) {
                    class_1309 l2;
                    class_1531 stand;
                    if (aoeTarget == player || aoeTarget == target || aoeTarget instanceof class_1531 && (stand = (class_1531)aoeTarget).method_6912() || !(target.method_5858(aoeTarget) < (double)rangeSq)) continue;
                    ++numTargets;
                    context = new ToolAttackContext((class_1309)player, player, hand, aoeTarget, aoeTarget instanceof class_1309 ? (l2 = (class_1309)aoeTarget) : null, false, 1.0f, true);
                    recipe.applyEffects(fluid.copy(), level, context);
                    SpillingModifier.spawnParticles(aoeTarget, fluid);
                }
                ToolDamageUtil.damageAnimated(tool, numTargets * level, (class_1309)player, hand);
            }
            player.method_7357().method_7906(tool.getItem(), (int)(20.0f / (tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue() * ConditionalStatModifierHook.getModifiedStat(tool, (class_1309)player, ToolStats.DRAW_SPEED))));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.ENTITY_INTERACT);
    }
}

